/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.network.SyncActionStateMessage;
import com.alrex.parcool.common.network.SyncStaminaMessage;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ActionProcessor {
    private final ByteBuffer bufferOfPostState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfPreState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfStarting = ByteBuffer.allocate(128);
    private int staminaSyncCoolTimeTick = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTickInClient(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.CLIENT) {
            return;
        }
        Player player = event.player;
        Animation animation = Animation.get(player);
        if (animation == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        animation.tick(player, parkourability);
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        Parkourability parkourability = Parkourability.get(player);
        IStamina stamina = IStamina.get(player);
        if (parkourability == null || stamina == null) {
            return;
        }
        List<Action> actions = parkourability.getList();
        boolean needSync = event.side == LogicalSide.CLIENT && player.m_7578_();
        SyncActionStateMessage.Encoder builder = SyncActionStateMessage.Encoder.reset();
        if (needSync) {
            stamina.tick();
            ++this.staminaSyncCoolTimeTick;
            if (this.staminaSyncCoolTimeTick > 5) {
                this.staminaSyncCoolTimeTick = 0;
                SyncStaminaMessage.sync(player);
            }
            if (stamina.isExhausted()) {
                player.m_6858_(false);
            }
        }
        parkourability.getAdditionalProperties().onTick(player, parkourability);
        block0: for (Action action : actions) {
            StaminaConsumeTiming timing = action.getStaminaConsumeTiming();
            if (needSync) {
                this.bufferOfPreState.clear();
                action.saveSynchronizedState(this.bufferOfPreState);
                this.bufferOfPreState.flip();
            }
            if (action.isDoing()) {
                action.setDoingTick(action.getDoingTick() + 1);
                action.setNotDoingTick(0);
            } else {
                action.setDoingTick(0);
                action.setNotDoingTick(action.getNotDoingTick() + 1);
            }
            action.onTick(player, parkourability, stamina);
            if (event.side == LogicalSide.CLIENT) {
                action.onClientTick(player, parkourability, stamina);
            } else {
                action.onServerTick(player, parkourability, stamina);
            }
            if (player.m_7578_()) {
                if (action.isDoing()) {
                    boolean canContinue = action.canContinue(player, parkourability, stamina);
                    if (!canContinue) {
                        action.setDoing(false);
                        action.onStopInLocalClient(player);
                        action.onStop(player);
                        builder.appendFinishMsg(parkourability, action);
                    }
                } else {
                    this.bufferOfStarting.clear();
                    boolean start = action.canStart(player, parkourability, stamina, this.bufferOfStarting);
                    this.bufferOfStarting.flip();
                    if (start) {
                        action.setDoing(true);
                        action.onStartInLocalClient(player, parkourability, stamina, this.bufferOfStarting);
                        this.bufferOfStarting.rewind();
                        action.onStart(player, parkourability);
                        builder.appendStartData(parkourability, action, this.bufferOfStarting);
                        if (timing == StaminaConsumeTiming.OnStart) {
                            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                }
            }
            if (action.isDoing()) {
                action.onWorkingTick(player, parkourability, stamina);
                if (event.side == LogicalSide.CLIENT) {
                    action.onWorkingTickInClient(player, parkourability, stamina);
                    if (player.m_7578_()) {
                        action.onWorkingTickInLocalClient(player, parkourability, stamina);
                        if (timing == StaminaConsumeTiming.OnWorking) {
                            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                } else {
                    action.onWorkingTickInServer(player, parkourability, stamina);
                }
            }
            if (!needSync) continue;
            this.bufferOfPostState.clear();
            action.saveSynchronizedState(this.bufferOfPostState);
            this.bufferOfPostState.flip();
            if (this.bufferOfPostState.limit() == this.bufferOfPreState.limit()) {
                while (this.bufferOfPreState.hasRemaining()) {
                    if (this.bufferOfPostState.get() == this.bufferOfPreState.get()) continue;
                    this.bufferOfPostState.rewind();
                    builder.appendSyncData(parkourability, action, this.bufferOfPostState);
                    continue block0;
                }
                continue;
            }
            this.bufferOfPostState.rewind();
            builder.appendSyncData(parkourability, action, this.bufferOfPostState);
        }
        if (needSync) {
            SyncActionStateMessage.sync(player, builder);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        for (Player player : clientPlayer.f_19853_.m_6907_()) {
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            List<Action> actions = parkourability.getList();
            for (Action action : actions) {
                action.onRenderTick(event, player, parkourability);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onViewRender(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        animation.cameraSetup(event, (Player)player, parkourability);
    }
}

